const express = require("express");
const router = express.Router();
const blogController = require("../controllers/blogController");
const authController = require("../controllers/authController"); // Assuming you have this
const {
  uploadBlogImage,
} = require("../storage/middlewareStorage/uploadBlogMedia");
const checkApiKey = require("../utils/checkApiKey");

// --- Public Routes (API Key Protected) ---
// Everyone can read blogs
router.route("/").get(checkApiKey, blogController.getAllBlogs);

router.route("/:id").get(checkApiKey, blogController.getBlog);

// --- Protected Routes (Admins & Instructors) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(uploadBlogImage, blogController.createBlog);

router
  .route("/:id")
  .patch(uploadBlogImage, blogController.updateBlog)
  .delete(blogController.deleteBlog);

module.exports = router;
